import LicenseSpring

import SwiftUI

struct ProductDetailsView: View {
    @Binding var productDetails: ProductDetails?
    
    var body: some View {
        if let productDetails = productDetails {
            VStack(alignment: .leading, spacing: 8) {
                KeyValueView(pair: ("Product Name", productDetails.productName))
                KeyValueView(pair: ("Product Code", productDetails.productCode))
                KeyValueView(pair: ("Is Trial Allowed", productDetails.isTrialAllowed))
                KeyValueView(pair: ("Trial Period", productDetails.trialPeriod))
                KeyValueView(pair: ("Authorization Type", productDetails.authorizationMethod))
                
                HStack {
                    Spacer()
                    MinWidthButton("Close") { self.productDetails = nil }
                    Spacer()
                }
                .padding(.top)
            }
            .padding()
        }
    }
}

struct ProductDetailsView_Previews: PreviewProvider {
    static var previews: some View {
        ProductDetailsView(productDetails: .constant(nil))
    }
}
